﻿using System.Collections.Generic;

namespace LinkedListExamples
{
    class Program
    {
        // Listing 9-13. Selekcja pacjentów w działaniu
        private LinkedList<Patient> waitingPatients = new LinkedList<Patient>();

        void Triage(Patient newPatient)
        {
            LinkedListNode<Patient> current = waitingPatients.First;
            while (current != null)
            {
                if (current.Value.AtImminentRiskOfDeath)
                {
                    current = current.Next;
                }
                else
                {
                    break;
                }
            }
            if (current == null)
            {
                waitingPatients.AddLast(newPatient);
            }
            else
            {
                waitingPatients.AddBefore(current, newPatient);
            }
        }

        static void Main(string[] args)
        {
        }
    }
}
